﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace WorldLab.MathLib
{
    /// vector
    public class Vector
    {
        /// number of rows
        private int nums;

        /// data buffer
        private double[] elements;

        public Vector(int n)
		{
			nums = n;
			Init(nums);
		}

        public Vector( Vector source)
		{
            nums = source.GetNums();
			Init(nums);
            SetData(source.elements);
		}

        public bool Init(int nRows)
        {
            nums = nRows;

            if (nums <= 0)
            {
                return false;
            }

            elements = new double[nums];

            return true;
        }

        public static Vector operator +(Vector v1, Vector v2)
        {
            return v1.Add(v2);
        }

        public static Vector operator -(Vector v1, Vector v2)
        {
            return v1.Subtract(v2);
        }

        public static double[] Create(int nRows)
        {
            double[] result = new double[nRows];
            return result;
        }

        public static double[] Duplicate(double[] vector)
        {
            double[] result = new double[vector.Length];
            for (int i = 0; i < vector.Length; ++i)
                result[i] = vector[i];
            return result;
        }

        public int GetNums()
        {
            return nums;
        }

        public bool SetElement(int index, double value)
        {
            if (index < 0 || index >= nums)
            {
                return false;
            }
            elements[index] = value;
            return true;
        }

        public double GetElement(int index)
        {
            return elements[index];
        }

        public void SetData(double[] value)
        {
            elements = (double[])value.Clone();
        }

        public Vector Add(Vector source)
        {
            // check number
            if (nums != source.GetNums())
            {
                throw new Exception("The two vectors does not match.");
            }
            Vector result = new Vector(this);
            for (int i = 0; i < nums; ++i)
            {
                result.SetElement(i, result.GetElement(i) + source.GetElement(i));
            }
            return result;
        }

        public Vector Subtract(Vector source)
        {
            // check number
            if (nums != source.GetNums())
            {
                throw new Exception("The two vectors does not match.");
            }
            Vector result = new Vector(this);
            for (int i = 0; i < nums; ++i)
            {
                result.SetElement(i, result.GetElement(i) - source.GetElement(i));
            }
            return result;
        }
        
        public void Release()
        {
            this.elements = null;
        }
    }
}
